/*****************************************************************************/
/*                         Freescale Semiconductor                           */
/*****************************************************************************/
/* File Type: Header                                                         */
/* File Name: Table.h                                                        */
/* Description: Header for showing tables on a TFT display                   */
/* Author: Jos Santiago Lpez Ramrez                                       */
/* Date: 30/09/10                                                            */
/*****************************************************************************/

#ifndef _Table_H_
  #define _Table_H_
  

/*****************************************************************************/
/*                                Includes                                   */
/*****************************************************************************/

  #include "FslTypes.h"
  #include "Rend_Characters.h"
  #include "SD.h"
  #include "Fat.h"
  #include "ButtonsHandler.h"
  
/*****************************************************************************/
/*                               Definitions                                 */
/*****************************************************************************/

  #define tblcolor         Darkblue    //Color of table lines
  #define thcolor          Darkblue    //Defines Header background color
  #define Tblbkg           thcolor       //Define Table background color
  #define Scolor           Black       //Defines the selected row color
  #define orwcolor         Lightblue   //Defines Odd Row Color
  #define prwcolor         White       //Defines Pair Row Color
  #define dietmcol         135        //Position where the second column starts on diet table
  #define rowend           10          //Character that produces a row change (10 = Line Feed)
  #define Buffer_SD        SDT_Buffer
  #define SD_Buffer_Size   8192
  #define Max_string_size  21          //Max string size for the Food Col
  #define CALORIES_FILE    (UINT8*)"CALREG.AMD"
  
/*****************************************************************************/
/*                                 Globals                                   */
/*****************************************************************************/

  /* Calories SD Handler Tasks */
   enum
  {
   SAVE_CALORIES,
   LOAD_CALORIES
  };
                                            
  extern UINT32 Pager[128];                    //Table Pager
  extern UINT8 gu8Table_Index;                         //Table gu8Table_Index
  extern UINT8 Page;                          //Table Data
  extern UINT8 Tdata[8][Max_string_size+7];    
  extern UINT8 SDT_Buffer[SD_Buffer_Size];    //Test Buffer Delete
  extern UINT32 Calctr;                       //Calories counter

/*****************************************************************************/
/*                                Functions                                  */
/*****************************************************************************/

     /**
     * \brief  This function fills a table row
     * \author Jos Santiago Lpez Ramrez
     * \param  UINT8 *string: Row information
     * \param  UINT8 RF: Red Foreground Component
     * \param  UINT8 GF: Green Foreground Component
     * \param  UINT8 BF: Blue Foreground Component
     * \param  UINT8 RB: Red Background Component
     * \param  UINT8 GB: Green Background Component
     * \param  UINT8 BB: Blue Background Component
     * \param  UINT8 line: Row number to be drawn (Max 9)
     * \return void
     * \todo   
     * \warning 
     */
     extern void Fill_Row (UINT8 *string, UINT8 RB, UINT8 GB, UINT8 BB, UINT8 RF, UINT8 GF, UINT8 BF, UINT8 line);
 
     
     /**
     * \brief  This function determines the number of pages of the table
     * \author Jos Santiago Lpez Ramrez
     * \param  void
     * \return Number of pages -1
     * \todo   
     * \warning 
     */
     UINT8 Table_Pager(UINT8 *SD_Buffer);
     
     
     /**
     * \brief  This function gets the table data for each page and draws it
     * \author Jos Santiago Lpez Ramrez
     * \param  void
     * \return void
     * \todo   
     * \warning 
     */
     extern void Fill_TableData (UINT8 *SD_Buffer);
     
     /**
     * \brief  This function adds the caloric value of the selected row to a Calories Register 
     * \author Jos Santiago Lpez Ramrez
     * \param  void
     * \return void
     * \todo   
     * \warning 
     */
     void Add_Engy(void);
     
     /**
     * \brief  This function shows the actual intaken calories value
     * \author Jos Santiago Lpez Ramrez
     * \param  void
     * \return void
     * \todo   
     * \warning 
     */
     void Show_Cal(void);
     
     /**
     * \brief  This function Manages the User Interface for the table
     * \author Jos Santiago Lpez Ramrez
     * \param  void
     * \return void
     * \todo   
     * \warning 
     */
     extern void Table_Manager (void);
     
     /**
     * \brief  This function gets table information from SD
     * \author Jos Santiago Lpez Ramrez
     * \param  void
     * \return void
     * \todo   
     * \warning Must be called before Table Manager 
     */
     void GetdatafromSD (void);
     
     
     extern UINT32 u32CaloriesCountSDHandler (UINT8 u8Task);
  
#endif  